// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
#ifndef COMPONENTS_AUTOFILL_IOS_FORM_UTIL_FORM_ACTIVITY_PARAMS_H_
#define COMPONENTS_AUTOFILL_IOS_FORM_UTIL_FORM_ACTIVITY_PARAMS_H_

#include <string>

namespace autofill {

// Wraps information about event happening in a form.
// Example HTML
// <form name="np" id="np1" action="https://example.com/" method="post">
// <input type="text" name="name" id="password_name"><br>
// <input type="password" name="password" id="password_field"><br>
// <input type="reset" value="Reset">
// <input type="submit" value="Submit" id="password_submit">
// </form>
// A tap on the password field will produce
// form_name:  "np"
// field_identifier:  "password_field"
// field_type:  "password"
// type: "focus"
// value: "LouisLane" (assuming that was the password typed)
// input_missing:  false
// frame_id: will be the unique ID generated in for the frame containing the
// form (see __gCrWeb.message.getFrameId for details).
struct FormActivityParams {
  FormActivityParams();
  FormActivityParams(const FormActivityParams& other);
  ~FormActivityParams();

  std::string form_name;
  // Generated by __gCrWeb.form.getFieldIdentifier in form.js.
  std::string field_identifier;
  std::string field_type;
  std::string type;
  std::string value;
  std::string frame_id;

  // |input_missing| is set to true if at least one of the members above isn't
  // set.
  bool input_missing = false;

  // |is_main_frame| is true when the activity was registered in the main frame.
  bool is_main_frame = false;

  // |has_user_gesture| is true when the activity was registered as a result of
  // a user action, and not by an event created and dispatched by JavaScript.
  bool has_user_gesture = false;
};

}  // namespace autofill

#endif  // COMPONENTS_AUTOFILL_IOS_FORM_UTIL_FORM_ACTIVITY_PARAMS_H_
